#!/bin/bash
# GCP Compute Engine LXC Deployment for HDGL Monolith

set -e

# Variables
PROJECT_ID="hdgl-project-2025"
ZONE="us-central1-a"
MACHINE_TYPE="e2-medium"
IMAGE_FAMILY="ubuntu-2404-lts"
NETWORK="default"
SUBNET="default"
INSTANCE_NAME="hdgl-aggregator"

# Create Firewall Rules
gcloud compute firewall-rules create hdgl-firewall --allow tcp:22,tcp:8080,tcp:9090 --source-ranges=0.0.0.0/0 --network $NETWORK

# Launch Aggregator Instance
gcloud compute instances create $INSTANCE_NAME \
    --project=$PROJECT_ID \
    --zone=$ZONE \
    --machine-type=$MACHINE_TYPE \
    --network-interface=network-tier=PREMIUM,subnet=$SUBNET \
    --metadata=startup-script='#!/bin/bash
    apt-get update && apt-get install -y lxc lxc-templates build-essential libssl-dev libgmp-dev cmake
    lxc-create -t ubuntu -n hdgl-aggregator -- -d ubuntu -r 24.04 -a amd64
    cp hdgl_monolith.c /var/lib/lxc/hdgl-aggregator/rootfs/root/
    lxc-execute -n hdgl-aggregator -- gcc -o /root/hdgl_monolith /root/hdgl_monolith.c -lssl -lcrypto -lgmp -lm
    lxc-start -n hdgl-aggregator -d -- /root/hdgl_monolith --mode=aggregator --port=8080 --max-nodes=10000' \
    --image-family=$IMAGE_FAMILY \
    --image-project=ubuntu-os-cloud \
    --boot-disk-size=50GB

echo "Aggregator Instance: $INSTANCE_NAME"

# Launch Managed Instance Group for Nodes
gcloud compute instance-templates create hdgl-node-template \
    --project=$PROJECT_ID \
    --zone=$ZONE \
    --machine-type=e2-micro \
    --network-interface=network-tier=PREMIUM,subnet=$SUBNET \
    --metadata=startup-script='#!/bin/bash
    apt-get update && apt-get install -y lxc lxc-templates build-essential libssl-dev libgmp-dev
    lxc-create -t ubuntu -n hdgl-node -- -d ubuntu -r 24.04 -a amd64
    cp hdgl_monolith.c /var/lib/lxc/hdgl-node/rootfs/root/
    lxc-execute -n hdgl-node -- gcc -o /root/hdgl_monolith /root/hdgl_monolith.c -lssl -lcrypto -lgmp -lm
    lxc-start -n hdgl-node -d -- /root/hdgl_monolith --mode=node --aggregator-endpoint=aggregator-ip:8080' \
    --image-family=$IMAGE_FAMILY \
    --image-project=ubuntu-os-cloud

gcloud compute instance-groups managed create hdgl-nodes-mig \
    --project=$PROJECT_ID \
    --zone=$ZONE \
    --size=1 \
    --template=hdgl-node-template \
    --max-size=10000

echo "Deployment complete. Aggregator: $INSTANCE_NAME, Nodes: hdgl-nodes-mig MIG"